﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Validation;

public partial class AdminEditUsers : BasePage
{
    private string _currentRegistry = Helpers.GetConfigEntry("Registry");

    USER userEntry;
    UsersManager usersManager = new UsersManager();

    public override string TopMenuName()
    {
        return "Administration";
    }
    
    public override string MenuItemName()
    {
        return "TBI ADMIN LIST USERS";
    }

    public override string AppObjectCode()
    {
        return "TBI ADMIN EDIT USERS";
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        
        if (!IsPostBack)
        {
            HiddenFieldBreadCrumbBaseText.Value = LabelBreadCrumb.Text;
            
            //if page is loading for first time get ID from querystring and set to hidden field to use on postbacks
            int? userID = Convert.ToInt32(Request.QueryString["id"]);
            HiddenFieldUserID.Value = userID.GetValueOrDefault().ToString();

            //Check if the request is to create a new item
            //a new item page request is signified when the querystring parameter id equals zero or is not present
            if (userID == null || userID == 0)
            {
                //set userID to zero so that a default linq entity will be instantiated
                userID = 0;

                //set page display for new item
                SetFormDisplay(true);

            }
            else
            {
                //set page to display for existing item
                SetFormDisplay(false);

            }
           
        }

        //Create User Entity object and Set properties to state of form
        getEntry(Convert.ToInt32(HiddenFieldUserID.Value));

        if (IsPostBack && userEntry != null)
        {
            LoadObjectFromControls();
        }
    }

    protected void getEntry(int id)
    {
        userEntry = usersManager.SelectByID(_currentRegistry, id);

        //initial display panels
        PanelNoAccess.Visible = false;
        PanelIdNotFound.Visible = false;
        PanelObjectContent.Visible = false;

        if (userEntry == null)
        {
            PanelObjectContent.Visible = false;

            if (usersManager.UserIDExists(id))
            {
                PanelNoAccess.Visible = true;
            }
            else
            {
                PanelIdNotFound.Visible = true;
            }
        }
        else
        {
            PanelObjectContent.Visible = true;
        }
    }


    void Page_PreRender(object sender, EventArgs e)
    {
        if (userEntry != null)
        {
            //This is the last event in the page life cycle where changes can be made to the page object
            //so enforce business rules on the object (which could possibly change the propertie of the object
            //then load the form controls from the object

            //Enforce business rules on the referral object
            //need to call EnforceBusinessRules method in the ReferralManager because some rules require a database call
            //pass in the local instance of referral to the method.  The method will return the object with modifications due to business rules.
            if (IsPostBack)
            {
                int ret;
                ret = usersManager.EnforceBusinessRules(ref userEntry);
            }

            //Load Controls from the Object
            LoadControlsFromObject();
            
        }

    }

    #region Object/Form Mapping

    private void LoadControlsFromObject()
    {

        //Username:
        TextBoxUsername.Text = userEntry.USERNAME;

        //Full Name:
        TextBoxFullName.Text = userEntry.FULL_NAME;

        //First Name:
        TextBoxFirstName.Text = userEntry.FIRST_NAME;

        //Middle Name:
        TextBoxMiddleName.Text = userEntry.MIDDLE_NAME;

        //Last Name:
        TextBoxLastName.Text = userEntry.LAST_NAME;

        //Maiden Name:
        TextBoxMaidenName.Text = userEntry.MAIDEN_NAME;
        
        //Employee Number:
        TextBoxEmployeeNumber.Text = userEntry.EMPLOYEE_NUMBER;

        //Job Title:
        TextBoxJobTitle.Text = userEntry.JOB_TITLE;
        
        //Email Address:
        TextBoxEmailAddress.Text = userEntry.EMAIL_ADDRESS;
        
        //Telephone:
        TextBoxTelephone.Text = userEntry.TELEPHONE_NUMBER;
        
        //Fax:
        TextBoxFax.Text = userEntry.FAX_NUMBER;

        //Created By:
        LabelCreatedBy.Text = userEntry.CREATEDBY;

        //Created On:
        LabelCreatedOn.Text = Helpers.getShortDateStringFromNullableDate(userEntry.CREATED);

        //Updated By:
        LabelUpdatedBy.Text = userEntry.UPDATEDBY;
        
        //Updated On:
        LabelUpdatedOn.Text = Helpers.getShortDateStringFromNullableDate(userEntry.UPDATED);
        
    }

    private void LoadObjectFromControls()
    {

        //Username:
        userEntry.USERNAME = TextBoxUsername.Text;

        //Full Name:
        userEntry.FULL_NAME = TextBoxFullName.Text;

        //First Name:
        userEntry.FIRST_NAME = TextBoxFirstName.Text;

        //Middle Name:
        userEntry.MIDDLE_NAME = TextBoxMiddleName.Text;

        //Last Name:
        userEntry.LAST_NAME = TextBoxLastName.Text;

        //Maiden Name:
        userEntry.MAIDEN_NAME = TextBoxMaidenName.Text;

        //Employee Number:
        userEntry.EMPLOYEE_NUMBER = TextBoxEmployeeNumber.Text;

        //Job Title:
        userEntry.JOB_TITLE = TextBoxJobTitle.Text;

        //Email Address:
        userEntry.EMAIL_ADDRESS = TextBoxEmailAddress.Text;

        //Telephone:
        userEntry.TELEPHONE_NUMBER = TextBoxTelephone.Text;

        //Fax:
        userEntry.FAX_NUMBER = TextBoxFax.Text;

    }

    #endregion

    #region Postback Events

    protected void ButtonSave_Click(object sender, EventArgs e)
    {
        int returnSaveValue;

        returnSaveValue = usersManager.Update(userEntry);
        this.SuppressSaveMessage = false;
        this.IsSaveSuccess = (returnSaveValue > 0);

        //Set Broken Rule Error Display
        if (userEntry.BrokenRules.Count == 0)
        {
            ErrorList1.Visible = false;

            //if inseted a new user and no errors, set the form to editing user mode.
            if (HiddenFieldInsertingNewUser.Value == "true")
            {
                HiddenFieldInsertingNewUser.Value = "false";
                HiddenFieldUserID.Value = userEntry.USER_ID.ToString();
                SetFormDisplay(false);
            }

        }
        else
        {
            ErrorList1.Visible = true;
        }

        ErrorList1.BrokenRules = userEntry.BrokenRules;

        //TO DO
        //Display Save Message
        //Refresh entity root data

        if (returnSaveValue != 0)
        {
            var master = (RegistryMaster)Master;
            master.SetDirtyFlag(false);
        }

    }

    protected void ButtonClose_Click(object sender, EventArgs e)
    {
        Response.Redirect("AdminListUsers.aspx");
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        this.TextBoxSearchCriteria.Text = "";
        SetFormDisplay(true);
    }

    protected void ButtonSearch_Click(object sender, EventArgs e)
    {
      
        userEntry = usersManager.SelectByUsername(TextBoxSearchCriteria.Text);

        if (userEntry != null)
        {
            HiddenFieldUserID.Value = userEntry.USER_ID.ToString();
            HiddenFieldSelectedUsername.Value = userEntry.USERNAME;

            if (usersManager.IsInRegistry(userEntry.USERNAME, _currentRegistry))
            {
                LabelUsernameIsInRegistry.Visible = true;
                ButtonViewEditUser.Visible = true;
            }
            else
            {
                LabelUsernameExists.Visible = true;
                GridViewUsers.Visible = true;
                ButtonAddUser.Visible = true;
                
                GridViewUsers.DataSourceID = "ObjectDataSourceUsers";
                GridViewUsers.DataBind();
            }

        }
        else
        {
            HiddenFieldUserID.Value = "0";
            HiddenFieldSelectedUsername.Value = "";

            if (!String.IsNullOrEmpty(TextBoxSearchCriteria.Text.Trim()))
            {
                getEntry(0);
                if (userEntry != null)
                    userEntry.USERNAME = TextBoxSearchCriteria.Text;
                SetFormForInsertNewUser(TextBoxSearchCriteria.Text);
            }
            else
            {
                ShowMessage("Please specify a user name for the search.");
            }
        }

    }

    protected void ButtonAddUser_Click(object sender, EventArgs e)
    {
        //if HiddenFieldSelectedUserID has a value, 
        //this signifies that the user selected to add an existing user to the current registry
        if (HiddenFieldSelectedUsername.Value != "")
        {
            userEntry = usersManager.SelectByUsername(TextBoxSearchCriteria.Text);
            HiddenFieldUserID.Value = userEntry.USER_ID.ToString();
            if (userEntry != null)
            {
                userEntry.SetAsChangeTrackingRoot();
            }
            //Add user to registry and display in edit mode
            if (usersManager.AddUserToRegistry(userEntry, _currentRegistry) == 1)
            {
                SetFormDisplay(false);
                getEntry(userEntry.USER_ID);
            }
            else
            {
                //could not add to registry
                ValidationErrorsCollection _BrokenRules = new ValidationErrorsCollection();
                _BrokenRules.Add(new ValidationError("ADMIN", "Could not add user to registry"));
                ErrorList1.BrokenRules = _BrokenRules;
                ErrorList1.Visible = true;
            }
        }
    }

    protected void ButtonViewEditUser_Click(object sender, EventArgs e)
    {
            SetFormDisplay(false);
    }

    #endregion


    protected void SetFormForInsertNewUser(string newUsername)
    {
    
        PanelNewUserSearchID.Visible = false;
        PanelUserInformation.Visible = true;
        TextBoxUsername.Text = newUsername;
        TextBoxUsername.ReadOnly = true;
        HiddenFieldInsertingNewUser.Value = "true";
        ButtonSave.Visible = true;
        TextBoxUsername.ReadOnly = true;
        TextBoxUsername.BackColor = System.Drawing.Color.LightGray;
        LabelCreatedBy.Visible = false;
        LabelCreatedOn.Visible = false;
        LabelUpdatedBy.Visible = false;
        LabelUpdatedOn.Visible = false;
        LabelCreatedByCaption.Visible = false;
        LabelCreatedOnCaption.Visible = false;
        LabelUpdatedByCaption.Visible = false;
        LabelUpdatedOnCaption.Visible = false;

    }


    protected void SetFormDisplay(bool isNewItem)
    {
        LabelBreadCrumb = (Label)Master.FindControl("LabelBreadCrumb");

        if (isNewItem)
        {
            //set page display for new item
            PanelNewUserSearchID.Visible = true;
            PanelUserInformation.Visible = false;
            ButtonSave.Visible = false;

            LabelUsernameExists.Visible = false;
            GridViewUsers.Visible = false;
            ButtonAddUser.Visible = false;
            LabelUsernameIsInRegistry.Visible = false;
            ButtonViewEditUser.Visible = false;

            //Modify breadcrumb to display adding new
            LabelBreadCrumb.Text = HiddenFieldBreadCrumbBaseText.Value + " > Add New User ";

        }
        else
        {
            //set page display for existing item 
            PanelNewUserSearchID.Visible = false;
            PanelUserInformation.Visible = true;
            ButtonSave.Visible = true;
            LabelCreatedByCaption.Visible = true;
            LabelCreatedOnCaption.Visible = true;
            LabelUpdatedByCaption.Visible = true;
            LabelUpdatedOnCaption.Visible = true;

            //Modify breadcrumb to display editing user id
            LabelBreadCrumb.Text = HiddenFieldBreadCrumbBaseText.Value + " > Edit User ID : " + HiddenFieldUserID.Value;
        }
    }

    protected void ShowMessage(string message)
    {
        string script = "<script language=\"javascript\"  type=\"text/javascript\">alert('" + message.Replace("'", "\\'") + "');</script>";
        ScriptManager.RegisterStartupScript(Page, this.GetType(), "AlertMessage", script, false);
    }
}
